% Test the method polysym.vpa
function test_suite = testVpa %#ok<*STOUT>
initTestSuite;

function d = setup
d = digits;
digits(40);

function testEmpty(~)
p = polysym.empty;
y = vpa(p);
assertTrue(isempty(y))

function testDefault(~)
p = polysym;
y = vpa(p);
assertTrue(double(y)==0) % conversion to double needed for R2011 and earlier

function testPi(~) %#ok<*DEFNU>
% Conversions do not recover the exact value, but they are accurate to the
% expected number of digits.
x = polysym(vpa(pi));
y = vpa(x);
assertTrue(abs(double(y-vpa(pi)))<10^(-digits+1))

function testI(~)
x = polysym(1i);
y = vpa(x);
assertTrue(y==vpa(1i))

function testStringReal(~)
x = polysym('(1+sqrt(5))/2');
y = vpa(x);
assertTrue(y==vpa('(1+sqrt(5))/2'))

function testStringMixed(~)
x = polysym('(1+sqrt(5))/2');
x = [x x*1i];
y = vpa(x);
assertTrue(all(y(1)==vpa('(1+sqrt(5))/2') && y(2)==1i*vpa('(1+sqrt(5))/2')))

function testArray(~)
x = repmat(polysym('(1+sqrt(5))/2'),2,4);
y = vpa(x);
tf = y == repmat(vpa('(1+sqrt(5))/2'),2,4);
assertTrue(all(tf(:)))

function testRand(~)
x = exp(1i*randn(3));
y = vpa(polysym(x));
tf = abs(double(y)-x) < eps*100;
assertTrue(all(tf(:)))

function testSetDigits(~)
% Again, the conversions are not exact, but are good to the number of
% digits expected (in this case, 3)
x = polysym(pi);
d = 3;
y = vpa(x,d);
assertTrue(abs(double(y-vpa(pi)))<10^(-d+1))

function teardown(d)
digits(d)